<?php
// src/OpenAIHandler.php

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/AdvancedHttpClient.php';
require_once __DIR__ . '/DataHandler.php';

class OpenAIHandler {
    private $httpClient;
    private $apiKey;
    private $dataHandler;

    public function __construct() {
        $this->httpClient = new AdvancedHttpClient();
        $this->apiKey = OPENAI_API_KEY;
        $this->dataHandler = new DataHandler();
    }

    public function getResponse($userMessage) {
        $priceData = $this->dataHandler->getLatestRates(); // دریافت آخرین قیمت‌ها
        $brandInfo = $this->dataHandler->getBrandInfo(); // دریافت اطلاعات برند

        $systemPrompt = $this->getAISystemPrompt($priceData, $brandInfo);

        $messages = [
            ["role" => "system", "content" => $systemPrompt],
            ["role" => "user", "content" => $userMessage]
        ];

        $url = OPENAI_BASE_URL . '/chat/completions';
        $data = [
            "model" => "gpt-3.5-turbo", // یا gpt-4 اگر دسترسی داشته باشید
            "messages" => $messages,
            "temperature" => 0.7,
            "max_tokens" => 1500,
        ];

        $headers = [
            'Authorization: Bearer ' . $this->apiKey,
            'Content-Type: application/json',
        ];

        $responseJson = $this->httpClient->post($url, json_encode($data), $headers);
        if (!$responseJson['success']) {
            error_log("OpenAI API request failed. Error: " . $responseJson['error']);
            if ($responseJson['data']) {
                $errorResponse = json_decode($responseJson['data'], true);
                if ($errorResponse && isset($errorResponse['error'])) {
                    error_log("OpenAI Error Details: " . print_r($errorResponse['error'], true));
                }
            }
            return false; // عدم موفقیت
        }

        $response = json_decode($responseJson['data'], true);

        if (isset($response['error'])) {
            error_log("OpenAI Error: " . print_r($response['error'], true));
            return false; // عدم موفقیت
        }

        if (isset($response['choices'][0]['message']['content'])) {
            return trim($response['choices'][0]['message']['content']);
        }

        return false; // عدم موفقیت
    }

    private function getAISystemPrompt($price_data = null, $brand_info = null) {
        $system_content = "شما یک ربات کمکی بسیار متخصص در زمینه قیمت طلا، سکه، ارز و بازارهای مالی هستید. شما توسط فروشگاه سیف گلد (safegold.store) ایجاد شده‌اید.\n\n";

        if ($brand_info) {
            $system_content .= "📋 اطلاعات کامل درباره برند سیف گلد:\n";
            $system_content .= $brand_info . "\n\n";
        }

        if ($price_data) {
            $system_content .= "📊 آخرین قیمت‌های بازار (در صورت وجود):\n";
            // فرض بر این است که $price_data یک آرایه PHP است که می‌توانید آن را فرمت کنید
            // بسته به ساختار واقعی API، این قسمت باید تغییر کند
            // مثال ساده:
            $system_content .= "دلار: " . ($price_data['data']['price']['dollar'] ?? 'نامشخص') . "\n";
            $system_content .= "یورو: " . ($price_data['data']['price']['euro'] ?? 'نامشخص') . "\n";
            $system_content .= "طلای 18 عیار: " . ($price_data['data']['price']['gold_18'] ?? 'نامشخص') . "\n";
            // اضافه کردن بقیه قیمت‌ها...
            $system_content .= "\n";
        }

        $system_content .= "اگر کاربر سوالی مربوط به طلا، سکه، ارز، سرمایه‌گذاری یا محصولات/خدمات فروشگاه سیف گلد بپرسد، پاسخی دقیق، مبتنی بر اطلاعات موجود و مفید ارائه دهید.\n";
        $system_content .= "اگر سوال از حوزه دانش شما خارج است، صریحاً بگویید که نمی‌دانید و از کاربر بخواهید از پشتیبانی استفاده کند.\n";
        $system_content .= "همیشه پاسخ خود را به زبان فارسی و صریح ارائه دهید.";
        $system_content .= "4. برای سوالات قیمت، از داده‌های لحظه‌ای استفاده کنید.";
        $system_content .= "5. برای سوالات درباره برند، از اطلاعات بخش 'سیف گلد' استفاده کنید.";
        $system_content .= "6. اگر اطلاعات کافی برای پاسخ ندارید، کاربر را به منابع دیگر (وبسایت، پشتیبانی) ارجاع دهید.";
        $system_content .= "7. در پاسخ‌های خود از نشان‌های مناسب (📈, 📉, 🏢, 📞, 🌐) استفاده کنید.";
        $system_content .= "8. همیشه مودب و مفید باشید.";

        return $system_content;
    }
}